/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionType;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public record HasBeehiveCondition(int honeyLevel, int distance) implements SpawnCondition
{
    public static final MapCodec<HasBeehiveCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)5).optionalFieldOf("honey_level", (Object)5).forGetter(HasBeehiveCondition::honeyLevel), (App)Codec.intRange((int)1, (int)32).fieldOf("distance").forGetter(HasBeehiveCondition::distance)).apply((Applicative)instance, HasBeehiveCondition::new));

    @Override
    public SpawnConditionType getType() {
        return FOTSpawnConditions.HAS_BEEHIVE;
    }

    @Override
    public boolean test(SpawnConditionContext context) {
        PoiManager poiManager = context.level().getPoiManager();
        Optional optional = poiManager.findClosest(type -> type.is(PoiTypes.BEEHIVE) || type.is(PoiTypes.BEE_NEST), context.blockPos(), this.distance, PoiManager.Occupancy.ANY);
        if (optional.isPresent()) {
            BlockState blockState = context.level().getBlockState((BlockPos)optional.get());
            return blockState.hasProperty((Property)BeehiveBlock.HONEY_LEVEL) && BeehiveBlockEntity.getHoneyLevel((BlockState)blockState) == this.honeyLevel;
        }
        return false;
    }

    public static SpawnCondition.Builder beehive(int honeyLevel, int distance) {
        return () -> new HasBeehiveCondition(honeyLevel, distance);
    }
}

